/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.processor;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.mixin.mixins.common.accessor.ChunkAccessAccessor;
import com.aetherteam.aether.world.BlockLogicUtil;
import com.aetherteam.aether.world.processor.AetherStructureProcessors;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class SurfaceRuleProcessor
extends StructureProcessor {
    public static final SurfaceRuleProcessor INSTANCE = new SurfaceRuleProcessor();
    public static final Codec<SurfaceRuleProcessor> CODEC = Codec.unit((Object)((Object)INSTANCE));

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos origin, BlockPos centerBottom, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo modifiedBlockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        if (level instanceof WorldGenLevel) {
            ServerChunkCache serverChunkCache;
            ChunkGenerator chunkGenerator;
            ChunkSource chunkSource;
            WorldGenLevel worldGenLevel = (WorldGenLevel)level;
            if (worldGenLevel instanceof WorldGenRegion) {
                WorldGenRegion region = (WorldGenRegion)worldGenLevel;
                if (BlockLogicUtil.isOutOfBounds(modifiedBlockInfo.f_74675_(), region.m_143488_())) {
                    return modifiedBlockInfo;
                }
            }
            if ((chunkSource = worldGenLevel.m_7726_()) instanceof ServerChunkCache && (chunkGenerator = (serverChunkCache = (ServerChunkCache)chunkSource).m_8481_()) instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                NoiseGeneratorSettings settingsHolder = (NoiseGeneratorSettings)noiseBasedChunkGenerator.m_224341_().get();
                SurfaceRules.RuleSource surfaceRule = settingsHolder.f_188871_();
                ChunkAccess chunkAccess = worldGenLevel.m_46865_(modifiedBlockInfo.f_74675_());
                NoiseChunk noisechunk = ((ChunkAccessAccessor)chunkAccess).aether$getNoiseChunk();
                if (noisechunk != null) {
                    CarvingContext carvingcontext = new CarvingContext(noiseBasedChunkGenerator, worldGenLevel.m_9598_(), chunkAccess.m_183618_(), noisechunk, serverChunkCache.m_214994_(), surfaceRule);
                    Optional state = carvingcontext.m_190646_(arg_0 -> ((BiomeManager)worldGenLevel.m_7062_()).m_204214_(arg_0), chunkAccess, modifiedBlockInfo.f_74675_(), false);
                    if (state.isPresent() && modifiedBlockInfo.f_74676_().m_204336_(AetherTags.Blocks.AETHER_DIRT) && !modifiedBlockInfo.f_74676_().m_60713_((Block)AetherBlocks.AETHER_DIRT.get()) && ((BlockState)state.get()).m_204336_(AetherTags.Blocks.AETHER_DIRT)) {
                        return new StructureTemplate.StructureBlockInfo(modifiedBlockInfo.f_74675_(), (BlockState)state.get(), null);
                    }
                }
            }
        }
        return modifiedBlockInfo;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)AetherStructureProcessors.SURFACE_RULE.get();
    }
}

